#!/bin/bash
export datasets="Cora CiteSeer wikics"
export datasets2="Cora CiteSeer PubMed cs wikics physics OGBN-Arxiv"
export missing_rates="0.9 0.99 0.999 0.9999"
export missing_rates_test="0.1"
export lambda_list="1e-5 1e-4 1e-3 1e-2 1e-1 1e+0 1e+1"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export pseudo_types="0 1 2"
export gpu=0

for dataset in $datasets
do
for missing_rate in $missing_rates
do
for pseudo_type in $pseudo_types
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --pseudo_type ${pseudo_type} --embedder GOODIE_best --n_runs 3 --gpu ${gpu}
python main.py --dataset ${dataset} --missing_type row --missing_rate ${missing_rate} --pseudo_type ${pseudo_type} --embedder GOODIE_best --n_runs 3 --gpu ${gpu}
done
done
done